;******************************************************************  
;That can't be modified by user.
;******************************************************************  
;INCLUDE "NPH_RX_MCU.inc"
INCLUDE "BC2502_RF_Set.inc"

;------------------------------------------------------------------        
BC2302_DS	.SECTION	'data'
mBuf		DB	12	DUP(?)
mTemp		DB	2	DUP(?)

BC2302_CS    .SECTION  PAGE	'code'
;--------------------------------------------------------
;--------------------------------------------------------
public	_NPH_RX_Init
_NPH_RX_Init		PROC
			MOV		A,LOW PrmTab
			MOV		TBLP,A
	IFDEF	TBHP
			MOV		A,HIGH PrmTab
			MOV		TBHP,A
	ENDIF				
			MOV		A,(PrmTabEnd-PrmTab)/2
			MOV		mBuf[3],A
	sbi_Lp:			
			TABRDC	mBuf[0]
			INC		TBLP
	IFDEF	TBHP
			SZ			Z
			INC		TBHP
	ENDIF
			TABRDC	mBuf[2]			
			INC		TBLP
	IFDEF	TBHP
			SZ			Z
			INC		TBHP
	ENDIF
			MOV		A,01h
			MOV		mBuf[1],A
			CALL		Write_I2C_Multi_Byte
			SDZ		mBuf[3]
			JMP		sbi_Lp
			RET			 
_NPH_RX_Init		ENDP

;--------------------------------------------------------
;--------------------------------------------------------
public		_Read_NPH_RX_Reg	
_Read_NPH_RX_Reg		PROC
			MOV		A,LOW PrmTab
			MOV		TBLP,A
	IFDEF	TBHP
			MOV		A,HIGH PrmTab
			MOV		TBHP,A
	ENDIF				
					
			MOV		A,(PrmTabEnd-PrmTab)/2
			MOV		mBuf[3],A
	Rbi_Lp:			
			TABRDC	mBuf[0]
			INC		TBLP
	IFDEF	TBHP
			SZ			Z
			INC		TBHP
	ENDIF
			TABRDC	mBuf[2]
			INC		TBLP
	IFDEF	TBHP
			SZ			Z
			INC		TBHP
	ENDIF
			MOV		A,01h
			MOV		mBuf[1],A
			CALL	Read_I2C_Multi_Byte
			SDZ		mBuf[3]
			JMP		Rbi_Lp
			RET

_Read_NPH_RX_Reg		ENDP
			
;------------------------------------
PrmTab:
;		DW	09h
;		DW	7Eh
		
;		DW	0Ah
;		DW	7Fh
		
		DW	BC_TEST3
		DW	BC_TEST3_V
		
		DW	BC_CFG1	
		DW	BC_CFG1_V
				
		DW	BC_FSKDM1
		DW	BC_FSKDM1_V
		
		DW	BC_FSKDM2
		DW	BC_FSKDM2_V
		
		DW	BC_OOKDM1
		DW	BC_OOKDM1_V
		
		DW	BC_OOKDM2
		DW	BC_OOKDM2_V

		DW	BC_LOG1
		DW	BC_LOG1_V
		
		DW	BC_AGC1
		DW	BC_AGC1_V
		
		DW	BC_AGC2
		DW	BC_AGC2_V
		
		DW	BC_AGC5
		DW	BC_AGC5_V
		
		DW	BC_OM
		DW	BC_OM_V
		
		DW	BC_RXG1
		DW	BC_RXG1_V

		DW	BC_SX1		
		DW	BC_SX1_V	
			
		DW	BC_SX2		
		DW	BC_SX2_V	
			
		DW	BC_SX3		
		DW	BC_SX3_V	
			
		DW	BC_SX4		
		DW	BC_SX4_V
		
		DW	BC_RX1
		DW	BC_RX1_V	
			
		DW	BC_XO1
		DW	BC_XO1_V

		DW	BC_CA1			
		DW	BC_CA1_V		
		
;-----1.2V-------
		DW	BC_CA3
		DW	BC_CA3_V+b_VCOCAL_EN
	
;		DW	BC_RTM1
;		DW	BC_RTM1_V
PrmTabEnd:								

;--------------------------------------------------------
public _Entry_I2C_mode
_Entry_I2C_mode	PROC
			SDA_LO
			SDA_OUT
			DELAY
			SCK_LO
			CALL	_Delay_1ms
			CALL	_Delay_1ms
			call   Delay_100us
			call   Delay_100us
			call   Delay_100us
			RET
_Entry_I2C_mode	ENDP

;--------------------------------------------------------
public _Exit_I2C_mode
_Exit_I2C_mode	PROC
			MOV		A,BC_I2C1
			MOV		mBuf[0],A
			MOV		A,01h
			MOV		mBuf[2],A			
			MOV		A,01h
			MOV		mBuf[1],A
			JMP		Write_I2C_Multi_Byte
_Exit_I2C_mode	ENDP

;--------------------------------------------------------
public _Set_DEM_mode
_Set_DEM_mode	PROC
			MOV		mBuf[0],A
			MOV		A,01h
			MOV		mBuf[2],A			
			MOV		A,01h
			MOV		mBuf[1],A
			JMP		Write_I2C_Multi_Byte
_Set_DEM_mode	ENDP

;********************************************************
;--------------------------------------------------------
; input    : mBuff[0]=addr. ,mBuff[1]=length, mBuff[9:2]=data
; template : MP0, mTemp[0], mTemp[1]
;--------------------------------------------------------
public Write_I2C_Multi_Byte
Write_I2C_Multi_Byte	PROC
			CALL	I2C_Start
			
			MOV		A,(DEVICE_NO<<1)
			CALL	I2C_SendByte
			CALL	I2C_GetAck
			SZ		C
			JMP		wimb_Fail
			
			MOV		A,mBuf[0]
			CALL	I2C_SendByte
			CALL	I2C_GetAck
			SZ		C
			JMP		wimb_Fail

			MOV		A,mBuf[1]
			MOV		mTemp[1],A
			MOV		A,OFFSET mBuf[2]
			MOV		MP0,A
	wimb_Lp:	
			MOV		A,IAR0
			CALL	I2C_SendByte
			CALL	I2C_GetAck
			SZ		C
			JMP		wimb_Fail
			INC		MP0					
			SDZ		mTemp[1]
			JMP		wimb_Lp
	wimb_Fail:
			CALL	I2C_Stop
			RET
Write_I2C_Multi_Byte	ENDP			

;--------------------------------------------------------
; input    : mBuff[0]=addr. ,mBuff[1]=length
; output   : mBuf[9:2]
; template : MP0, mTemp[0], mTemp[1]
;--------------------------------------------------------
Read_I2C_Multi_Byte	PROC
			CALL	I2C_Start
			
			MOV		A,(DEVICE_NO<<1)
			CALL	I2C_SendByte
			CALL	I2C_GetAck
			SZ		C
			JMP		rimb_Fail
			
			MOV		A,mBuf[0]
			CALL	I2C_SendByte
			CALL	I2C_GetAck
			SZ		C
			JMP		rimb_Fail
			
			CALL	I2C_Start
			
			MOV		A,(DEVICE_NO<<1)+1
			CALL	I2C_SendByte
			CALL	I2C_GetAck
			SZ		C
			JMP		rimb_Fail
			
			MOV		A,OFFSET mBuf[2]
			MOV		MP0,A									
			MOV		A,mBuf[1]
			MOV		mTemp[1],A
	rimb_Lp:	
			CALL	I2C_GetByte
			MOV		IAR0,A
			INC		MP0
			
			SET		C
			SDZA	mTemp[1]			
			CLR		C
			CALL	I2C_SendAck
			SDZ		mTemp[1]	
			JMP		rimb_Lp
			
	rimb_Fail:			
			CALL	I2C_Stop
			RET
Read_I2C_Multi_Byte	ENDP			

;********************************************************
;--------------------------------------------------------
public	_I2C_Init
_I2C_Init		PROC
			SDA_HI		
			SCK_HI		
			CLR		SCK_DIR
			CLR		SDA_DIR
			
			MOV		A,32
			MOV		mTemp,A
		LOOP:
			CALL		_Delay_1ms
			SDZ		mTemp
			
			JMP		LOOP
			ret
_I2C_Init		ENDP

public	_RX_Off
_RX_Off		PROC
			SCK_HI
;			SDA_OUT
			RET
_RX_Off		ENDP

public	_RX_On
_RX_On		PROC
			SDA_IN
			SCK_LO
			RET
_RX_On		ENDP

;--------------------------------------------------------
public	I2C_Start
I2C_Start	PROC
			I2C_STR
			RET
I2C_Start	ENDP
				
;--------------------------------------------------------
;--------------------------------------------------------
public	I2C_Stop
I2C_Stop	PROC
			I2C_STP
			RET
I2C_Stop	ENDP
				
;--------------------------------------------------------
; Input : ACC=Data
; Template : mTemp[0]
;--------------------------------------------------------
public	I2C_SendByte
I2C_SendByte	PROC
			SDA_OUT
			MOV		mTemp,A
			MOV		A,08h
	isb_Lp:		
			SCK_LO
			RLC		mTemp
			SZ		C
			JMP		$1			
	$0:
			SDA_LO
			JMP		$9						
	$1:		
			SDA_HI	
	$9:	
			JMP		$+1
			SCK_HI
			DELAY
			SDZ		ACC
			JMP		isb_Lp
			SCK_LO
			SDA_IN			
			RET
I2C_SendByte	ENDP

;--------------------------------------------------------
; Template : mTemp[0]
; Output : ACC
;--------------------------------------------------------
public I2C_GetByte
I2C_GetByte	PROC
			SDA_IN
			MOV		A,08h
	igb_Lp:		
			SCK_LO
			DELAY
			
			SCK_HI
			CLR		C
			SZ_SDA
			SET		C			
			RLC		mTemp
			
			SDZ		ACC
			JMP		igb_Lp
			
			SCK_LO
			MOV		A,mTemp			
			RET
I2C_GetByte	ENDP

;--------------------------------------------------------
; Input : C
;--------------------------------------------------------
I2C_SendAck	PROC
			SDA_OUT
			SZ		C
			JMP		$1
	$0:
			SDA_LO
			JMP		$9			
	$1:				
			SDA_HI	
	$9:
			SCK_HI
			DELAY
			SCK_LO
			RET
I2C_SendAck	ENDP

;--------------------------------------------------------
; Output : C
;--------------------------------------------------------
I2C_GetAck	PROC
			SDA_IN
;			DELAY
			SCK_HI
			DELAY
			CLR		C
			SZ_SDA
			SET		C		
			SCK_LO
			RET
I2C_GetAck	ENDP

;--------------------------------------------------------
;void	InitRxTM(void);
;--------------------------------------------------------
;public	_InitRxTM
;_InitRxTM	proc
;			InitRxTM
;			RET
;_InitRxTM	endp

;--------------------------------------------------------
;void	RFTimerOn(void);
;--------------------------------------------------------
;public	_RFTimerOn
;_RFTimerOn	proc
;			RFTimerOn
;			RET
;_RFTimerOn	endp

;--------------------------------------------------------
;void	RFTimerOff(void);
;--------------------------------------------------------
;public	_RFTimerOff
;_RFTimerOff	proc
;			RFTimerOff
;			RET
;_RFTimerOff	endp

;--------------------------------------------------------
;fsys=8Mhz
;--------------------------------------------------------
public	Delay_10us
Delay_10us	PROC
			MOV		A,4
			NOP
			SDZ		ACC
			JMP		$-2
			RET
Delay_10us	ENDP

;--------------------------------------------------------
;fsys=8Mhz
;--------------------------------------------------------
public	Delay_100us
Delay_100us	PROC
			MOV		A,49
			NOP
			SDZ		ACC
			JMP		$-2
			RET
Delay_100us	ENDP

;--------------------------------------------------------
;fsys=8Mhz
;--------------------------------------------------------
public	_Delay_1ms
_Delay_1ms	PROC
			MOV		A,167
			SDZ		ACC
			JMP		$-1
			
			MOV		A,166
			SDZ		ACC
			JMP		$-1
			
			MOV		A,166
			SDZ		ACC
			JMP		$-1

			MOV		A,166
			SDZ		ACC
			JMP		$-1
			
			RET
_Delay_1ms	ENDP
		